#!/bin/bash

DIR_OK="/okfiles"
DIR_KO="/kofiles"
DIR_ANALIZAR="/analizar"

# Declaramos un array que contine las palabras clave sospechosas
PALABRAS_BAN=("hacker" "cracker" "phreaker" "carder")

for FICHERO in "$DIR_ANALIZAR"/* ; do 
    # Declaramos una variable con el valor de sospechosos a 0
    SOSPECHOSO=0
    
    # Con el bucle while recorremos las lineas del fichero encontrado
    while read -r LINEA ; do
        for PALABRA in "${PALABRAS_BAN[@]}"; do
            if [[ "$LINEA" == *"$PALABRA"* ]]; then
                # Si la línea del fichero contiene alguna de las palabras sospechosas del array, cambiamos el valor de la variable sospechoso a 1
                SOSPECHOSO=1
                # No hay mas condiciones que evaluar, por lo tanto se sale de este bucle for
                # Ya no hay más líneas que cumplan la condición del if, por lo tanto se sale del bucle for
                break 2
            fi
        done
    done < "$FICHERO"
    
    if [ $SOSPECHOSO -eq 1 ]; then
        echo "$FICHERO es sospechoso"
        sudo mv "$FICHERO" "$DIR_KO"
    else
        echo "$FICHERO no es sospechoso"
        sudo mv "$FICHERO" "$DIR_OK"
    fi
done