#!/bin/bash

FICHERO="/shared/usu_dir.csv"

# Solo root puede ejecutar el script
if [ $UID -ne 0 ]; then
    echo "Permiso denegado. Necesitas ejecutarlo con sudo"
    exit 1
fi 

if [ ! -f "$FICHERO" ]; then
    echo "$FICHERO no existe"
    exit 2
fi

for LINEA in $(cat "$FICHERO") ; do
    USUARIO=$(echo "$LINEA" | cut -d"," -f1)
    CARPETA=$(echo "$LINEA" | cut -d"," -f2)
    
    if [ -z "$USUARIO" ] || [ -z "$CARPETA" ]; then
        echo "Error, falta algún campo en el fichero $FICHERO"
    elif  ! cat "/etc/passwd" | grep "$USUARIO" ; then
        echo "El usuario $USUARIO no existe en el sistema"
    else
        echo "Creando la carpeta $CARPETA para el usuario $USUARIO..."
        mkdir /home/$USUARIO/$CARPETA
        chown -R $USUARIO:$USUARIO /home/$USUARIO/$CARPETA
        chmod 775 -R /home/$USUARIO/$CARPETA
    fi
done
