#!/bin/bash

# Comprobamos que al menos nos meten un argumento por la línea de comandos
if [ $# -eq 0 ]; then
    echo "Uso: $0 <fichero1> [fichero2]"
    exit 1
fi

for FICHERO in "$@"; do
    if [ -f "$FICHERO" ]; then
        read -p "¿Desea vaciar el contenido de $FICHERO? Aviso esta acción es irreversible. (s/N): " R
            if [ "$R" = "S" ] || [ "$R" = "s" ]; then
                echo "Vaciando el fichero $FICHERO..."
                truncate --size=0 $FICHERO
                if [ $? -eq 0 ]; then
                    echo "Se ha vaciado correctamente el contenido del fichero $FICHERO"
                else
                    echo "¡Ups! Hubo un error al vaciar el contenido del fichero $FICHERO"
                fi
            else
                echo "Operación cancelada por el usuario"
            fi
    else
        echo "$FICHERO no existe"
    fi
done