# Comprobamos que nos han introducido el argumento con el fichero
if [ $# -lt 1 ] || [ $# -gt 1 ]; then
    echo "Uso $0: <fichero>"
    exit 1
fi

# Comprobamos si existe el fichero de donde coger la información para crear la carpeta
if [ ! -f "$1" ]; then
    echo "El fichero $1 no existe"
    exit 2
fi

# Procesamos el fichero, sabemos que el fichero está delimitado por ;

while read -r LINEA; do
    USUARIO=$(echo $LINEA | cut -d";" -f1)
    CARPETA=$(echo $LINEA | cut -d";" -f2)
    
    # Comprobamos que los campos del usuario y carpeta existen en el fichero
    if [ -z "$USUARIO" ] || [ -z "$CARPETA" ]; then
        echo "Error, el campo usuario o  el campo carpeta está vacío en el fichero"
    # En caso que estén todos los campos rellenos en el fichero, comprobamos si el usuario existe en el sistema o si la carpeta ya existe
    elif ! (cat "/etc/passwd" | grep "$USUARIO") ; then
        echo "El usuario $USUARIO no existe en el sistema"
    elif [ -d "$CARPETA" ]; then
        echo "$CARPETA ya existe en el sistema, por lo que no se creará"
    else
        echo "Procesando la línea $LINEA..."
        mkdir /home/$USUARIO/$CARPETA
        if [ $? -eq 0 ]; then
            echo "Se ha creado correctamente la carpeta $CARPETA en el directorio home del usuario $USUARIO"
        else
            echo "Ocurrió un error al crear la carpeta $CARPETA del usuario $USUARIO"
        fi
    fi
done < "$1"