#!/bin/bash

# Solo root puede ejecutar este script

if [ $UID -ne 0 ]; then
    echo "Error, permiso denegado. Necesita privilegios máximos para ejecutar este script"
    exit 1
fi

# Comprobamos que nos introducen un fichero como argumento por la línea de comandos

if [ $# -eq 0 ]; then
    echo "Uso: $0 <fichero1> [fichero2]"
    exit 2
fi

for ARCHIVO in $@ ; do
    if [ -f "$ARCHIVO" ]; then
        for LINEA in $(cat $ARCHIVO); do
            #Extraemos la información del usuario. El fichero tiene los campos delimitados por comas
            USUARIO=$(echo $LINEA | cut -d"," -f1)
            GRUPO=$(echo $LINEA | cut -d"," -f2)
            CLAVE=$(echo $LINEA | cut -d"," -f3)
            echo "Creando a el usuario $USUARIO...."
            # Comando para crear usuarios en Linux
            /usr/sbin/useradd -m -g $GRUPO -s /bin/bash $USUARIO
            # Ponerle la contraseña al usuario
            echo "$USUARIO:$CLAVE" | chpasswd
        done
    else
        echo "El fichero $ARCHIVO no existe"
    fi
done


            
