#!/bin/bash

# 1.- Debe crear la carpeta /Proy-Pru. Si existe la borra y después la crea.
CARPETA="/Proy-Pru"

if [ -d "$CARPETA" ]; then
    sudo rm -r "$CARPETA"
fi
sudo mkdir "$CARPETA"

# 2.- Cree en la carpeta /Proy-Pru las carpetas asociadas a los proyectos en las líneas válidas.
FICHERO="input.txt"
ROLES_VALIDOS=("Operario" "Asistente" "Ingeniero")

# Leer el fichero línea por línea
while IFS=, read -r EMPLEADO ROL CARPETA_PROYECTO; do
    echo "Procesando la fila: Usuario=$EMPLEADO, Rol=$ROL, Proyecto=$CARPETA_PROYECTO"
    
    if [ -z "$CARPETA_PROYECTO" ]; then
        echo "No se ha especificado un proyecto. Fila anulada"
        continue
    fi

    if ! [[ " ${ROLES_VALIDOS[@]} " =~ " $ROL " ]]; then
        echo "El rol $ROL no existe. Fila anulada"
        continue
    fi

    if [ -z "$EMPLEADO" ]; then
        echo "No se ha especificado un empleado. Fila anulada"
        continue
    fi

    if [ -z "$ROL" ]; then
        echo "No se ha especificado un rol. Fila anulada"
        continue
    fi

    # Verificar si la carpeta ya existe
    if [ -d "$CARPETA/$CARPETA_PROYECTO" ]; then
        echo "La carpeta $CARPETA_PROYECTO ya ha sido creada"
    else
        sudo mkdir "$CARPETA/$CARPETA_PROYECTO"
        echo "Creando la carpeta $CARPETA_PROYECTO"
    fi
done < "$FICHERO"

