#!/bin/bash

# Busca los procesos zombie y muestra el PID y el nombre del proceso.
zombies=$(ps -eo pid,state,comm | grep " Z")

if [[ -n "$zombies" ]]; then
    echo "Procesos zombies detectados:"
    echo "$zombies" | while read -r line; do
        PID=$(echo "$line" | tr -s ' ' | cut -d ' ' -f 1)
        COMANDO=$(echo "$line" | tr -s ' ' | cut -d ' ' -f 3)
        echo "PID: $PID, Proceso: $COMANDO"
    done
else
    echo "No se han detectado procesos zombies"
fi


