#!/bin/bash

FICHERO="usuarios.csv"

if [ ! -f "$FICHERO" ]; then
    echo "$FICHERO no existe"
    exit 1
fi


while IFS="," read -r LINEA ; do
    USUARIO=$(echo $LINEA | cut -d"," -f1)
    GRUPO=$(echo $LINEA | cut -d"," -f2)
    CLAVE=$(echo $LINEA | cut -d"," -f3)
    
    
    if [ -z "$USUARIO" ] || [ -z "$GRUPO" ] || [ -z "$CLAVE" ]; then
        echo "Error, falta algún campo en la línea"
    elif [[ ! "$USUARIO" =~ ^[A-Za-z]{1,15}$ ]]; then
        echo "Error, la longitud de la cuenta de usuario es mayor a 15 caracteres"
    elif cat "/etc/passwd" | grep "$USUARIO" ; then
        echo "El usuario ya existe en el sistema"
    elif cat "/etc/group" | grep "$GRUPO" ; then
        echo "El grupo ya existe en el sistema"
    else
        echo "Creando el usuario $USUARIO..."
        # Creamos el usuario y le añadimos al grupo que pertenece y la shell
        /usr/sbin/useradd -m -g $GRUPO -s /bin/bash $USUARIO
        # Al usuario le ponemos su contraseña
        echo "$USUARIO:$CLAVE" | chpasswd
    fi
done < "$FICHERO"
