#!/bin/bash

FICHERO="grupos.txt"

for LINEA in $(cat "$FICHERO"); do
    echo "Procesando la fila: $LINEA"
    if [ -z "$LINEA" ]; then
        echo "La linea está vacía"
    elif [[ ! "$LINEA" =~ ^[A-Za-z]{1,15}$ ]]; then
        echo "El grupo $LINEA supera los 15 caracteres, por tanto no se va a crear"
    elif cat "/etc/group" | grep $LINEA; then
        echo "El grupo $GRUPO ya existe"
    else
        echo "Creando el grupo $LINEA"
        sudo groupadd "$LINEA"
        if [ $? -eq 0 ]; then
            echo "El grupo $LINEA se ha creado correctamente"
        else
            echo "Error al crear el grupo $LINEA"
        fi
    fi
Done